﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

class Plane
{
    public string Identifier
    {
        get;
        set;
    }

    const double kilometersPerMile = 1.609344;

    public double SpeedInMilesPerHour
    {
        get
        {
            return SpeedInKilometersPerHour / kilometersPerMile;
        }
        set
        {
            SpeedInKilometersPerHour = value * kilometersPerMile;
        }
    }

    public double SpeedInKilometersPerHour
    {
        get;
        set;
    }

    public DirectionOfApproach Direction
    {
        get;
        set;
    }

    public PolarPoint3D Position
    {
        get;
        set;
    }

    public void SendMessage(
        string messageName,
        TimeSpan delay = default(TimeSpan))
    {
    }

    // Listing 3-40. Jawny dostęp do składowych
    public void UpdatePosition(double minutesToAdvance)
    {
        double hours = minutesToAdvance / 60;
        double milesMoved = this.SpeedInMilesPerHour * hours;
        double milesToTower = this.Position.Distance;
        if (this.Direction == DirectionOfApproach.Approaching)
        {
            milesToTower -= milesMoved;
            if (milesToTower < 0)
            {
                // Dolecieliśmy!
                milesToTower = 0;
            }
        }
        else
        {
            milesToTower += milesMoved;
        }
        PolarPoint3D newPosition = new PolarPoint3D(
            milesToTower,
            this.Position.Angle,
            this.Position.Altitude);
    }
}